/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference;

import java.util.Collection;
import java.util.Map;

import com.kportal.extension.module.IModule;


public interface ModuleReference {

	/**
	 * méthode d'initialisation pour charger les références
	 */
	public void init();

	/**
	 *  la liste des modules sur lesquels on va calculer les références
	 *  si null = tous les modules
	 *  si vide = aucun
	 */
	public Collection<IModule> getModules();

	/**
	 * la liste des modules à mettre à jour pour les codes de fiche
	 */
	public Map<String, Collection<String>> getModulesBySearchStringForCode();

	/**
	 * la liste des modules à mettre à jour pour les ids de fiche
	 */
	public Map<String, Collection<String>> getModulesBySearchStringForId();

}
