/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference;

import java.util.Collection;
import java.util.Map;

import org.apache.commons.collections.MapUtils;

import com.kportal.extension.module.IModule;
import com.kportal.extension.module.utils.ServiceContenuModuleHelper;


public class ModuleReferenceHelper {

	public static Collection<ModuleReference> getFichesReferences(){
		return ServiceContenuModuleHelper.getServiceContenuModuleManager().getModulesReferences();
	}

	public static boolean containsModule(ModuleReference moduleReference, String idModule){
		for (IModule module : moduleReference.getModules()) {
			if (module.getId().equals(idModule)){
				return Boolean.TRUE;
			}
		}
		return Boolean.FALSE;
	}

	public static void addAllModules(String currentIdModule, final BeanReference referencesById, final BeanReference referencesByCode) {

		for (ModuleReference moduleFicheReference : ServiceContenuModuleHelper.getServiceContenuModuleManager().getModulesReferences()) {
			if (moduleFicheReference.getModules() == null || containsModule(moduleFicheReference, currentIdModule)) {
				final Map<String, Collection<String>> modulesForId = moduleFicheReference.getModulesBySearchStringForId();
				final Map<String, Collection<String>> modulesForCode = moduleFicheReference.getModulesBySearchStringForCode();
				if (referencesById!=null && MapUtils.isNotEmpty(modulesForId)) {
					referencesById.addAllModulesBySearchString(modulesForId);
				}
				if (referencesByCode != null && MapUtils.isNotEmpty(modulesForCode)) {
					referencesByCode.addAllModulesBySearchString(modulesForCode);
				}
			}
		}
	}
}
