/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;

import com.kosmos.usinesite.reference.ModuleReference;
import com.kportal.extension.module.IModule;

public class DefaultModuleReference implements ModuleReference {

	/**
	 * la liste des modules sur lesquels on va calculer la référence
	 */
	public Collection<IModule> modules;

	/**
	 * la liste des modules sur lesquels on va appliquer une mise à jour du code
	 */
	public Map<String, Collection<String>> modulesBySearchStringForCode;

	/**
	 * la liste des modules sur lesquels on va appliquer une mise à jour de l'id
	 */
	public Map<String, Collection<String>> modulesBySearchStringForId;

	@Override
	public void init() {}

	@Override
	public Collection<IModule> getModules() {
		return modules;
	}

	@Override
	public Map<String, Collection<String>> getModulesBySearchStringForCode() {
		return modulesBySearchStringForCode;
	}

	@Override
	public Map<String, Collection<String>> getModulesBySearchStringForId() {
		return modulesBySearchStringForId;
	}

	public void setModules(Collection<IModule> modules) {
		this.modules = modules;
	}

	public void setModulesBySearchStringForCode(Map<String, Collection<String>> modulesBySearchStringForCode) {
		this.modulesBySearchStringForCode = modulesBySearchStringForCode;
	}

	public void setModulesBySearchStringForId(Map<String, Collection<String>> modulesBySearchStringForId) {
		this.modulesBySearchStringForId = modulesBySearchStringForId;
	}

	@SuppressWarnings("unchecked")
	public void addModulesBySearchStringForCode(final String value, final Collection<String> modules) {
		if (modulesBySearchStringForCode == null) {
			modulesBySearchStringForCode = new HashMap<>();
		}
		if (modulesBySearchStringForCode.containsKey(value)) {
			modulesBySearchStringForCode.put(value, CollectionUtils.union(modulesBySearchStringForCode.get(value), modules));
		} else {
			modulesBySearchStringForCode.put(value, modules);
		}
	}

	@SuppressWarnings("unchecked")
	public void addModulesBySearchStringForId(final String value, final Collection<String> modules) {
		if (modulesBySearchStringForId == null) {
			modulesBySearchStringForId = new HashMap<>();
		}
		if (modulesBySearchStringForId.containsKey(value)) {
			modulesBySearchStringForId.put(value, CollectionUtils.union(modulesBySearchStringForId.get(value), modules));
		} else {
			modulesBySearchStringForId.put(value, modules);
		}
	}
}
