/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import com.kosmos.usinesite.exception.ErreurReferenceException;
import com.kosmos.usinesite.reference.BeanReference;
import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kosmos.usinesite.reference.processor.ReferenceProcessor;
import com.kportal.extension.module.bean.EncadreBeanExport;
import com.univ.objetspartages.om.Encadre;
import com.univ.utils.ContexteDao;

public class EncadreServiceBeanReference implements ServiceBeanReference {

	@Override
	public Collection<BeanReference> check(final Map<String, ? extends Serializable> beansOrig, final ReferenceProcessor processor) throws ErreurReferenceException {
		// cette méthode regarde si le meta existe et si c'est le cas, créé un nouvel id
		final EncadreBeanExport encadreBean = (EncadreBeanExport) beansOrig.values().iterator().next();
		final Collection<BeanReference> beansReferences = new ArrayList<>();
		final BeanReference referenceById = new BeanReference();
		referenceById.addModulesBySearchString("\"id_encadre\":\"" + S1 + "\"", Arrays.asList(encadreBean.getIdModule()));
		final BeanReference referenceByCode = new BeanReference();
		referenceByCode.addModulesBySearchString("\"code\":\"" + S1 + "\"", Arrays.asList(encadreBean.getIdModule()));
		for (final String codeEncadre : beansOrig.keySet()) {
			try (ContexteDao ctx = new ContexteDao()) {
				final Encadre encadre = new Encadre();
				encadre.init();
				encadre.setCtx(ctx);
				// si l'encadre existe
				if (encadre.select("WHERE CODE='" + codeEncadre + "'") > 0) {
					encadre.nextItem();
					referenceById.addNewValueByOldValue(encadre.getIdEncadre().toString(), "0");
					referenceByCode.addNewValueByOldValue(encadre.getCode(), String.valueOf(System.nanoTime()));
				}
			} catch (final Exception e) {
				throw new ErreurReferenceException("Erreurs lors de la récupération des encadres", e);
			}
		}
		beansReferences.add(referenceById);
		beansReferences.add(referenceByCode);
		return beansReferences;
	}
}
