/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference.impl;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import org.springframework.beans.BeanUtils;

import com.jsbsoft.jtf.database.JDBCUtils;
import com.kosmos.usinesite.exception.ErreurReferenceException;
import com.kosmos.usinesite.reference.BeanReference;
import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kosmos.usinesite.reference.processor.ReferenceProcessor;
import com.kportal.cms.objetspartages.annotation.GetterAnnotationHelper;
import com.kportal.extension.module.bean.AbstractBeanExport;
import com.univ.mediatheque.Mediatheque;
import com.univ.objetspartages.bean.MediaBean;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteDao;
import com.univ.utils.json.NamingStrategyHelper;

public class MediaServiceBeanReference implements ServiceBeanReference {

	final private BeanReference beanReference = new BeanReference();

	@Override
	public Collection<BeanReference> check(final Map<String, ? extends Serializable> beansOrig, final ReferenceProcessor processor) throws ErreurReferenceException {
		final Collection<BeanReference> referencesToUpdate = new ArrayList<>();
		beanReference.addModulesBySearchString("\"id_media\":\"" + S1 + "\"", Collections.<String> emptyList());
		beanReference.addModulesBySearchString("\\[id-fichier\\]" + S1 + "\\[\\/id-fichier\\]", Collections.<String> emptyList());
		beanReference.addModulesBySearchString("\\[id-image\\]" + S1 + "\\[\\/id-image\\]", Collections.<String> emptyList());
		beanReference.addModulesBySearchString("\\[legende-image\\]" + S1 + "\\[\\/legende-image\\]", Collections.<String> emptyList());
		beanReference.addModulesBySearchString("\\[title-image\\]" + S1 + "\\[\\/title-image\\]", Collections.<String> emptyList());
		Long maxIdMedia;
		try (ContexteDao ctxUtils = new ContexteDao()) {
			maxIdMedia = JDBCUtils.getNextAutoIncrement(ctxUtils.getConnection(), "MEDIA", beansOrig.keySet().size());
		} catch (final Exception e) {
			throw new ErreurReferenceException("Une erreur est survenue lors de la réservation des clés primaires.", e);
		}
		for (final String idMedia : beansOrig.keySet()) {
			try (ContexteDao ctx = new ContexteDao()) {
				// on teste la présence en base du média grâce à son id
				final Media media = new Media();
				media.setCtx(ctx);
				media.setIdMedia(new Long(idMedia));
				try {
					media.retrieve();
					// si le média est mutualise et que la source est la même on ne réimporte pas le fichier
					if (media.getIsMutualise().equals(Mediatheque.ETAT_MUTUALISE) && media.getUrl().equals(((MediaBean) beansOrig.get(idMedia)).getUrl())) {
						continue;
					}
				} catch (final Exception e) {
					continue;
				}
				beanReference.addNewValueByOldValue(idMedia, Long.toString(maxIdMedia));
				maxIdMedia--;
			} catch (final Exception e) {
				throw new ErreurReferenceException("Erreur lors de la récupération du media", e);
			}
		}
		referencesToUpdate.add(beanReference);
		return referencesToUpdate;
	}

	public void addSearchStringForBean(final AbstractBeanExport<?> bean, final Collection<String> modules) {
		for (final Method method : GetterAnnotationHelper.getMethodIdMedia(bean.getBean())) {
			final PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
			beanReference.addModulesBySearchString("\"" + NamingStrategyHelper.translateUppercaseToUnderscore(pd.getName()) + "\":\"" + S1 + "\"", modules);
		}
	}
}
