/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.database.JDBCUtils;
import com.kosmos.usinesite.exception.ErreurReferenceException;
import com.kosmos.usinesite.reference.BeanReference;
import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kosmos.usinesite.reference.processor.ReferenceProcessor;
import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.extension.module.bean.PluginFicheBeanExport;
import com.kportal.extension.module.plugin.objetspartages.om.ObjetPluginContenu;
import com.univ.objetspartages.bean.AbstractPersistenceBean;
import com.univ.objetspartages.bean.MediaBean;
import com.univ.objetspartages.om.AbstractOm;
import com.univ.utils.ContexteDao;

public class PluginFicheServiceBeanReference implements ServiceBeanReference {

	/**
	 * cette méthode regarde si la fiche existe et si c'est le cas, on créé un nouveau id fiche
	 */
	@SuppressWarnings("deprecation")
	@Override
	public Collection<BeanReference> check(final Map<String, ? extends Serializable> beansOrig, final ReferenceProcessor processor) throws ErreurReferenceException {
		final Collection<BeanReference> referencesToUpdate = new ArrayList<>();
		final Map<ObjetPluginContenu, Map<String, MediaBean>> objetsContenus = new HashMap<>();
		PluginFicheBeanExport<?> pluginFicheBean = null;
		for (final String idBean : beansOrig.keySet()) {
			final PluginFicheBeanExport<?> currentFicheBean = (PluginFicheBeanExport<?>) beansOrig.get(idBean);
			// on ne traite que les objets (et pas les sous objets exportés dans la même map)
			ObjetPluginContenu currentObjet;
			try {
				currentObjet = updateObjectValues(currentFicheBean);
			} catch (final Exception e) {
				throw new ErreurReferenceException("Erreur lors du calcul des références", e);
			}
			if (currentObjet != null) {
				objetsContenus.put(currentObjet, currentFicheBean.getMedias());
				pluginFicheBean = currentFicheBean;
			}
		}
		final BeanReference referencesById = new BeanReference();
		final Collection<String> moduleToSearch = new ArrayList<>();
		moduleToSearch.add(pluginFicheBean.getIdModule());
		final String nomTableSql = StringUtils.substringAfterLast(pluginFicheBean.getClasseObjet(), ".").toUpperCase();
		Long maxIdPlugin;
		try (ContexteDao ctxUtils = new ContexteDao()) {
			maxIdPlugin = JDBCUtils.getNextAutoIncrement(ctxUtils.getConnection(), nomTableSql, objetsContenus.size());
		} catch (final Exception e) {
			throw new ErreurReferenceException("Une erreur est survenue lors de la réservation des clés primaires.", e);
		}
		for (final ObjetPluginContenu currentObjet : objetsContenus.keySet()) {
			try (ContexteDao ctx = new ContexteDao()) {
				try {
					currentObjet.setCtx(ctx);
					currentObjet.retrieve();
				} catch (final Exception e) {
					continue;
				}
				referencesById.addNewValueByOldValue(currentObjet.getIdObjet().toString(), maxIdPlugin.toString());
				// mise à jour de l'id sur les sous objets potentiels
				referencesById.addModulesBySearchString("\"id_" + nomTableSql.toLowerCase() + "\":\"" + S1 + "\"", moduleToSearch);
				// traitement des médias associés
				if (MapUtils.isNotEmpty(objetsContenus.get(currentObjet))) {
					final MediaServiceBeanReference mediaServiceBeanRef = new MediaServiceBeanReference();
					mediaServiceBeanRef.addSearchStringForBean(pluginFicheBean, moduleToSearch);
					referencesToUpdate.addAll(mediaServiceBeanRef.check(objetsContenus.get(currentObjet), processor));
				}
				maxIdPlugin--;
			} catch (final Exception e) {
				throw new ErreurReferenceException("erreur lors du calcul des références", e);
			}
		}
		referencesToUpdate.add(referencesById);
		return referencesToUpdate;
	}

	/**
	 * Instancie un objet et set ses valeurs via les données du beanAMapper
	 *
	 * @param beanAMapper
	 *            Le bean contenant les valeurs venant de l'export
	 * @return une FicheUniv du type contenu dans le bean à mapper
	 * @throws IllegalAccessException
	 *             Lors de la recopie des properties via BeanUtils
	 * @throws InvocationTargetException
	 *             Lors de la recopie des properties via BeanUtils
	 * @throws ClassNotFoundException
	 * @throws InstantiationException
	 */
	@SuppressWarnings("unchecked")
	private <T extends AbstractPersistenceBean> ObjetPluginContenu updateObjectValues(final PluginFicheBeanExport<?> beanAMapper) throws IllegalAccessException,
		InvocationTargetException, InstantiationException, ClassNotFoundException {
		final Object object = Class.forName(beanAMapper.getClasseObjet()).newInstance();
		if (object instanceof ObjetPluginContenu) {
			final ObjetPluginContenu objetPluginContenu = (ObjetPluginContenu) object;
			objetPluginContenu.init();
			if (object instanceof AbstractOm<?, ?>) {
				final AbstractOm<T, ?> fiche = (AbstractOm<T, ?>) object;
				final Class<T> clazz = (Class<T>) fiche.getPersistenceBean().getClass();
				fiche.setPersistenceBean(clazz.cast(beanAMapper.getBean()));
			} else {
				UASOmHelper.copyProperties(objetPluginContenu, beanAMapper.getBean());
			}
			return (ObjetPluginContenu) object;
		}
		return null;
	}
}
