/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.service.impl.RubriqueServiceContenuModule;

public class RubriqueFicheReference extends DefaultModuleReference {

	@Override
	public void init() {
		String s1 = ServiceBeanReference.S1;
		RubriqueServiceContenuModule service = (RubriqueServiceContenuModule) ApplicationContextManager.getCoreContextBean(RubriqueServiceContenuModule.ID_BEAN);
		if (service != null) {
			if (CollectionUtils.isNotEmpty(service.getModules())) {
				List<String> idModules = new ArrayList<>();
				for (IModule module : service.getModules()) {
					idModules.add(module.getId());
				}
				// mise à jour du code de page d'accueil ex "page_accueil":"{\"code\":\"64932802\",\"langue\":\"0\",\"objet\":\"pagelibre\"}",
				addModulesBySearchStringForCode("\"page_accueil\":\"\\{\\\\\"code\\\\\":\\\\\""+s1+"\\\\\",\\\\\"langue\\\\\"", idModules);
			}
		}
	}
}
