/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import com.kosmos.usinesite.exception.ErreurReferenceException;
import com.kosmos.usinesite.reference.BeanReference;
import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kosmos.usinesite.reference.processor.ReferenceProcessor;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.utils.ContexteDao;

public class RubriquePublicationServiceBeanReference implements ServiceBeanReference {

	@Override
	public Collection<BeanReference> check(final Map<String, ? extends Serializable> beansOrig, final ReferenceProcessor processor) throws ErreurReferenceException {
		// cette méthode regarde si le meta existe et si c'est le cas, créé un nouvel id
		final Collection<BeanReference> beansReferences = new ArrayList<>();
		final BeanReference beanRef = new BeanReference();
		for (final String idRubPub : beansOrig.keySet()) {
			beansOrig.get(idRubPub);
			try (ContexteDao ctx = new ContexteDao()) {
				final Rubriquepublication rub = new Rubriquepublication();
				rub.init();
				rub.setCtx(ctx);
				rub.setIdRubriquepublication(new Long(idRubPub));
				try {
					rub.retrieve();
				} catch (final Exception e) {
					continue;
				}
				// on passe les ids à zero
				beanRef.addNewValueByOldValue(idRubPub, "0");
			} catch (final Exception e) {
				throw new ErreurReferenceException("Erreur lors de la récupération de la rubrique de publication", e);
			}
		}
		beansReferences.add(beanRef);
		return beansReferences;
	}
}
