/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.bean;

import java.util.List;

import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.kosmos.usinesite.template.service.ServiceTemplateSite;

/**
 * Représentation d'un template de site.<br/>
 * Un template de site est une intégration graphique qu'il est possible d'appliquer à un site géré par l'usine à site. La personnalisation de ce template est possible via le jeu de
 * JSPs<br/>
 * <br/>
 * <strong>Un dossier de JSPs ne peut être utilisé que par un seul template.</strong> Si cette contrainte n'est pas respecté, l'usine à site ne fonctionnera pas correctement
 * (méthode {@link ServiceTemplateSite#getTemplateSiteParDossier(String)} non fonctionnelle)
 *
 * @author pierre.cosson
 *
 */
public interface TemplateSite {

	/**
	 * Identifiant unique d'un template de site.
	 *
	 * @return
	 */
	public abstract String getCode();

	/**
	 * Intitulé du template.
	 *
	 * @return
	 */
	public abstract String getIntitule();

	/**
	 * Description du template.
	 *
	 * @return
	 */
	public abstract String getDescription();

	/**
	 * URL relative de la vignette de présentation du template.
	 *
	 * @return
	 */
	public abstract String getUrlVignette();

	/**
	 * Dossier de JSP utilisé par le template.<br/>
	 * <strong>Un dossier de JSPs ne peut être utilisé que par un seul template.</strong>
	 *
	 * @return
	 */
	public abstract String getDossierJSP();

	/**
	 * Récupère la propriété du site identifié par le code fourni en paramètre
	 * 
	 * @param code
	 *            l'identifiant de la propriété
	 * @return la valeur de la propriété ou null si non trouvé.
	 */
	public abstract TemplateSiteProperty getProprieteComplementaire(String code);

	/**
	 * Récupérer l'ensemble des propriétés définies sur le sites
	 *
	 * @return
	 */
	public abstract List<TemplateSiteProperty> getListeProprietesComplementaires();
}