/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.bean.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;

public class TemplateSiteImpl implements TemplateSite {

	public String code = StringUtils.EMPTY;

	public String intitule = StringUtils.EMPTY;

	public String description = StringUtils.EMPTY;

	public String urlVignette = StringUtils.EMPTY;

	public String dossierJSP = StringUtils.EMPTY;

	public boolean cssSpecifique = Boolean.FALSE;

	public List<TemplateSiteProperty> listeProprietesComplementaires = Collections.<TemplateSiteProperty> emptyList();

	public Map<String, TemplateSiteProperty> mapProprietesComplementaires = Collections.<String, TemplateSiteProperty> emptyMap();

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSite#getCode()
	 */
	@Override
	public String getCode() {
		return code;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSite#getIntitule()
	 */
	@Override
	public String getIntitule() {
		return intitule;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSite#getDescription()
	 */
	@Override
	public String getDescription() {
		return description;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSite#getUrlVignette()
	 */
	@Override
	public String getUrlVignette() {
		return urlVignette;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSite#getDossierJSP()
	 */
	@Override
	public String getDossierJSP() {
		return dossierJSP;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSite#isCssSpecifique()
	 */
	public boolean isCssSpecifique() {
		return cssSpecifique;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.template.bean.TemplateSite#
	 * getListeProprietesComplementaires()
	 */
	@Override
	public List<TemplateSiteProperty> getListeProprietesComplementaires() {
		return listeProprietesComplementaires;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kosmos.usinesite.template.bean.TemplateSite#getProprieteComplementaire
	 * (java.lang.String)
	 */
	@Override
	public TemplateSiteProperty getProprieteComplementaire(final String code) {
		return mapProprietesComplementaires.get(code);
	}

	public void setCode(final String code) {
		this.code = code;
	}

	public void setIntitule(final String intitule) {
		this.intitule = intitule;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public void setUrlVignette(final String urlVignette) {
		this.urlVignette = urlVignette;
	}

	public void setDossierJSP(final String dossierJSP) {
		this.dossierJSP = dossierJSP;
	}

	public void setCssSpecifique(final boolean cssSpecifique) {
		this.cssSpecifique = cssSpecifique;
	}

	public void setListeProprietesComplementaires(final List<TemplateSiteProperty> listeProprieteComplementaire) {
		this.listeProprietesComplementaires = listeProprieteComplementaire;
		initialiserMapProprietesComplementaire();
	}

	private void initialiserMapProprietesComplementaire() {
		// acces concurent
		mapProprietesComplementaires = new HashMap<String, TemplateSiteProperty>(listeProprietesComplementaires.size());
		for (final TemplateSiteProperty property : listeProprietesComplementaires) {
			mapProprietesComplementaires.put(property.getCode(), property);
		}
	}
}
