/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.bean.impl;

import org.apache.commons.lang3.StringUtils;

import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;

public class AbstractTemplateSiteProperty implements TemplateSiteProperty {

	public String code = StringUtils.EMPTY;
	public String libelle = StringUtils.EMPTY;
	public String description = StringUtils.EMPTY;
	public boolean obligatoire = Boolean.FALSE;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSiteProperty#getCode()
	 */
	public String getCode() {
		return code;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSiteProperty#getLibelle()
	 */
	public String getLibelle() {
		return libelle;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSiteProperty#getDescription()
	 */
	public String getDescription() {
		return description;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.kosmos.usinesite.bean.TemplateSiteProperty#isObligatoire()
	 */
	public boolean isObligatoire() {
		return obligatoire;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public void setLibelle(String libelle) {
		this.libelle = libelle;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setObligatoire(boolean obligatoire) {
		this.obligatoire = obligatoire;
	}

}
