/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.bean.impl;

import java.util.Collection;
import java.util.Collections;

import org.apache.commons.lang3.StringUtils;

public class TemplateSitePropertyColor extends TemplateSitePropertyString {

	private static final int TAILLE_MAX = 7;

	private String valeurDefaut = StringUtils.EMPTY;

	private int tailleMaximum = TAILLE_MAX;

	private String regExpValidation = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";

	private Collection<String> listeValeursAutorisees = Collections.<String> emptyList();

	@Override
	public String getValeurDefaut() {
		return valeurDefaut;
	}

	@Override
	public void setValeurDefaut(final String valeurDefaut) {
		this.valeurDefaut = valeurDefaut;
	}

	@Override
	public int getTailleMaximum() {
		return tailleMaximum;
	}

	@Override
	public void setTailleMaximum(final int tailleMaximum) {
		this.tailleMaximum = tailleMaximum;
	}

	@Override
	public String getRegExpValidation() {
		return regExpValidation;
	}

	@Override
	public void setRegExpValidation(final String regExpValidation) {
		this.regExpValidation = regExpValidation;
	}

	@Override
	public Collection<String> getListeValeursAutorisees() {
		return listeValeursAutorisees;
	}

	@Override
	public void setListeValeursAutorisees(final Collection<String> listeValeursAutorisees) {
		this.listeValeursAutorisees = listeValeursAutorisees;
	}
}
