/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.bean.impl;

import java.util.Collection;
import java.util.Collections;

import org.apache.commons.lang3.StringUtils;

import com.kportal.core.config.PropertyHelper;

public class TemplateSitePropertyFichier extends AbstractTemplateSiteProperty {

	private static final long TAILLE_MAXIMUM_FICHIER;
	static {
		final String tailleMaxJTF = PropertyHelper.getCoreProperty("fichiergw.maxsize");
		if (StringUtils.isNotEmpty(tailleMaxJTF)) {
			TAILLE_MAXIMUM_FICHIER = Long.parseLong(tailleMaxJTF);
		} else {
			TAILLE_MAXIMUM_FICHIER = 1024;
		}
	}

	/**
	 * taille exprimée en Ko
	 */
	private long tailleMaximumFichier = TAILLE_MAXIMUM_FICHIER;

	private Collection<String> listeExtensionsAutorisees = Collections.<String> emptyList();

	public long getTailleMaximumFichier() {
		return tailleMaximumFichier;
	}

	public void setTailleMaximumFichier(final long tailleMaximumFichier) {
		this.tailleMaximumFichier = tailleMaximumFichier;
	}

	public Collection<String> getListeExtensionsAutorisees() {
		return listeExtensionsAutorisees;
	}

	public void setListeExtensionsAutorisees(final Collection<String> listeExtensionsAutorisees) {
		this.listeExtensionsAutorisees = listeExtensionsAutorisees;
	}
}
