/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.formateur.impl;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.FormateurJSP;
import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyFichier;
import com.kosmos.usinesite.template.property.formateur.TemplateSitePropertyHTMLFormateur;
import com.kosmos.usinesite.template.utils.ComposantFichierSimpleUpload;
import com.kosmos.usinesite.utils.FrontUASHelper;
import com.univ.multisites.InfosSite;

public class TemplateSitePropertyFichierHTMLFormateur implements TemplateSitePropertyHTMLFormateur<TemplateSitePropertyFichier> {

	public String formater(InfosSite infosSite, TemplateSite template, TemplateSitePropertyFichier property, FormateurJSP fmt, InfoBean data)
			throws Exception {
		String nomComponsant = FrontUASHelper.genererNameInputProprieteTemplate(template, property);
		String intituleFichierDepuisInfosSite = infosSite.getProprieteComplementaireString(property.getCode());
		if (StringUtils.isNotEmpty(intituleFichierDepuisInfosSite)) {
			ComposantFichierSimpleUpload.initialiserInfoBean(nomComponsant, intituleFichierDepuisInfosSite, data);
		} else {
			ComposantFichierSimpleUpload.initialiserInfoBean(nomComponsant, StringUtils.EMPTY, data);
		}
		// FAKE spéficique Usine Site sur le fait que la donnée est obligatoire
		// (ne pas utiliser le FRAMEWORK pour gérer le fait que le fichier est
		// obligatoire)
		String libelleComposant = property.getLibelle();
		if (property.isObligatoire()) {
			libelleComposant = "<span class=\"obligatoire\">" + libelleComposant + " *</span>";
		}
		return ComposantFichierSimpleUpload.genererChampsHTMLFichierSimpleUpload(nomComponsant, libelleComposant, fmt, data,
				Boolean.FALSE) + FrontUASHelper.genererMessageInformatif(property.getDescription());
	}
}
