/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.formateur.impl;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.FormateurJSP;
import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyMultilignes;
import com.kosmos.usinesite.template.property.formateur.TemplateSitePropertyHTMLFormateur;
import com.kosmos.usinesite.utils.FrontUASHelper;
import com.univ.multisites.InfosSite;

public class TemplateSitePropertyMultilignesHTMLFormateur implements TemplateSitePropertyHTMLFormateur<TemplateSitePropertyMultilignes> {

	@Override
	public String formater(final InfosSite infosSite, final TemplateSite template, final TemplateSitePropertyMultilignes property, final FormateurJSP fmt, final InfoBean data)
		throws Exception {
		final String nomComponsant = FrontUASHelper.genererNameInputProprieteTemplate(template, property);
		final StringBuilder out = new StringBuilder();
		out.append("<p><label class=\"colonne\" for=\"").append(nomComponsant).append("\">");
		if (property.isObligatoire()) {
			out.append("<span class=\"obligatoire\">").append(property.libelle).append(" * </span>");
		} else {
			out.append(property.libelle);
		}
		out.append(FrontUASHelper.genererMessageInformatif(property.getDescription()));
		out.append("</label>");
		final String valeur = StringUtils.defaultString(infosSite.getProprieteComplementaireString(property.getCode()), property.getValeurDefaut());
		out.append(FrontUASHelper.genererTexteareaHTML(nomComponsant, nomComponsant, valeur, property.getTailleMaximum(), StringUtils.EMPTY, property.getValeurDefaut(),
			Boolean.FALSE));
		out.append("</p>");
		return out.toString();
	}
}
