/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.service;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.kosmos.usinesite.template.property.extracteur.TemplateSitePropertyExtracteur;
import com.kosmos.usinesite.template.property.formateur.TemplateSitePropertyHTMLFormateur;
import com.kosmos.usinesite.template.property.traitement.TemplateSitePropertyTraitement;
import com.kosmos.usinesite.template.property.validateur.TemplateSitePropertyValidateur;

public interface ServiceTemplateSiteProperty {

	/**
	 * Récupérer l'extracteur de données correspondant à la propriété.
	 *
	 * @param property la property dont on souhaite connaitre l'extracteur
	 * @return l'extracteur du type de la property fourni en parametre
	 * @throws ErreurDonneeNonTrouve
	 *             une {@link ErreurDonneeNonTrouve} si aucun extracteur ne correspond à la propriété.
	 */
	public TemplateSitePropertyExtracteur<TemplateSiteProperty, Object> getTemplateSitePropertyExtracteur(TemplateSiteProperty property) throws ErreurDonneeNonTrouve;

	/**
	 * Permet de récupérer la classe validant la property fourni en paramètre
	 * @param property la property dont on souhaite connaitre le validateur
	 * @return le validateur du type de la property fourni en parametre
	 * @throws ErreurDonneeNonTrouve
	 *             une {@link ErreurDonneeNonTrouve} si aucun validateur ne correspond à la propriété.
	 */
	public TemplateSitePropertyValidateur<TemplateSiteProperty> getTemplateSitePropertyValidateur(TemplateSiteProperty property) throws ErreurDonneeNonTrouve;

	/**
	 * Permet de récupérer la classe de traitement supplémentaire de la property fourni en paramètre
	 * @param property la property dont on souhaite connaitre le traitement supplémentaire à faire
	 * @return le traitement supplémentaire du type de la property fourni en parametre
	 * @throws ErreurDonneeNonTrouve
	 *             une {@link ErreurDonneeNonTrouve} si aucun traitement ne correspond à la propriété.
	 */
	public TemplateSitePropertyTraitement<TemplateSiteProperty> getTemplateSitePropertyTraitement(TemplateSiteProperty property) throws ErreurDonneeNonTrouve;

	/**
	 * Permet de récupérer la classe du formateur de la property fourni en paramètre
	 * @param property la property dont on souhaite connaitre le formateur pour l'affichage
	 * @return le formateur du type de la property fourni en parametre
	 * @throws ErreurDonneeNonTrouve
	 *             une {@link ErreurDonneeNonTrouve} si aucun formateur ne correspond à la propriété.
	 */
	public TemplateSitePropertyHTMLFormateur<TemplateSiteProperty> getTemplateSitePropertyFormateur(TemplateSiteProperty property) throws ErreurDonneeNonTrouve;
}