/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.service;

import com.jsbsoft.jtf.core.ApplicationContextManager;

public class ServiceTemplateSitePropertyFactory {

	public static final String ID_BEAN = "serviceTemplateSitePropertyFactory";

	private ServiceTemplateSiteProperty serviceTemplateSitePropertyInstance = null;

	/**
	 * Récupérer le singleton de la factory.
	 * 
	 * @return
	 */
	private static ServiceTemplateSitePropertyFactory getInstance() {
		return (ServiceTemplateSitePropertyFactory) ApplicationContextManager.getBean(ApplicationContextManager.DEFAULT_CORE_CONTEXT, ID_BEAN);
	}

	public void setServiceTemplateSiteProperty(final ServiceTemplateSiteProperty serviceTemplateSiteProperty) {
		serviceTemplateSitePropertyInstance = serviceTemplateSiteProperty;
	}

	/**
	 * Récupérer l'instance de {@link ServiceTemplateSiteProperty} de l'application.
	 * 
	 * @return L'instance (singleton).
	 */
	public static ServiceTemplateSiteProperty getServiceTemplateSite() {
		return getInstance().serviceTemplateSitePropertyInstance;
	}
}
