/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.service.impl;

import java.util.Collections;
import java.util.Map;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.kosmos.usinesite.template.property.extracteur.TemplateSitePropertyExtracteur;
import com.kosmos.usinesite.template.property.formateur.TemplateSitePropertyHTMLFormateur;
import com.kosmos.usinesite.template.property.service.ServiceTemplateSiteProperty;
import com.kosmos.usinesite.template.property.traitement.TemplateSitePropertyTraitement;
import com.kosmos.usinesite.template.property.validateur.TemplateSitePropertyValidateur;

public class ServiceTemplateSitePropertyImpl implements ServiceTemplateSiteProperty {

	private Map<String, TemplateSitePropertyExtracteur<TemplateSiteProperty, Object>> mapExtracteur = Collections.emptyMap();

	private Map<String, TemplateSitePropertyValidateur<TemplateSiteProperty>> mapValidateur = Collections.emptyMap();

	private Map<String, TemplateSitePropertyTraitement<TemplateSiteProperty>> mapTraitement = Collections.emptyMap();

	private Map<String, TemplateSitePropertyHTMLFormateur<TemplateSiteProperty>> mapFormateur = Collections.emptyMap();

	public void setMapExtracteur(final Map<String, TemplateSitePropertyExtracteur<TemplateSiteProperty, Object>> mapExtracteur) {
		this.mapExtracteur = mapExtracteur;
	}

	public void setMapValidateur(final Map<String, TemplateSitePropertyValidateur<TemplateSiteProperty>> mapValidateur) {
		this.mapValidateur = mapValidateur;
	}

	public void setMapTraitement(final Map<String, TemplateSitePropertyTraitement<TemplateSiteProperty>> mapTraitement) {
		this.mapTraitement = mapTraitement;
	}

	public void setMapFormateur(final Map<String, TemplateSitePropertyHTMLFormateur<TemplateSiteProperty>> mapFormateur) {
		this.mapFormateur = mapFormateur;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kosmos.usinesite.template.property.service.ServiceTemplateSiteProperty
	 * #
	 * getTemplateSitePropertyExtracteur(com.kosmos.usinesite.template.property.
	 * bean.TemplateSiteProperty)
	 */
	@Override
	public TemplateSitePropertyExtracteur<TemplateSiteProperty, Object> getTemplateSitePropertyExtracteur(final TemplateSiteProperty property) throws ErreurDonneeNonTrouve {
		final String cleMap = property.getClass().getName();
		final TemplateSitePropertyExtracteur<TemplateSiteProperty, Object> extracteur = mapExtracteur.get(cleMap);
		if (extracteur != null) {
			return extracteur;
		} else {
			throw new ErreurDonneeNonTrouve("Impossible de trouver l'extracteur de données pour la property : " + cleMap);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kosmos.usinesite.template.property.service.ServiceTemplateSiteProperty
	 * #
	 * getTemplateSitePropertyValidateur(com.kosmos.usinesite.template.property.
	 * bean.TemplateSiteProperty)
	 */
	@Override
	public TemplateSitePropertyValidateur<TemplateSiteProperty> getTemplateSitePropertyValidateur(final TemplateSiteProperty property) throws ErreurDonneeNonTrouve {
		final String cleMap = property.getClass().getName();
		final TemplateSitePropertyValidateur<TemplateSiteProperty> validateur = mapValidateur.get(cleMap);
		if (validateur != null) {
			return validateur;
		} else {
			throw new ErreurDonneeNonTrouve("Impossible de trouver le validateur de données pour la property : " + cleMap);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kosmos.usinesite.template.property.service.ServiceTemplateSiteProperty
	 * #
	 * getTemplateSitePropertyTraitement(com.kosmos.usinesite.template.property.
	 * bean.TemplateSiteProperty)
	 */
	@Override
	public TemplateSitePropertyTraitement<TemplateSiteProperty> getTemplateSitePropertyTraitement(final TemplateSiteProperty property) throws ErreurDonneeNonTrouve {
		final String cleMap = property.getClass().getName();
		final TemplateSitePropertyTraitement<TemplateSiteProperty> traitement = mapTraitement.get(cleMap);
		if (traitement != null) {
			return traitement;
		} else {
			throw new ErreurDonneeNonTrouve("Impossible de trouver le traitement pour la property : " + cleMap);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kosmos.usinesite.template.property.service.ServiceTemplateSiteProperty
	 * #
	 * getTemplateSitePropertyFormateur(com.kosmos.usinesite.template.property.bean
	 * .TemplateSiteProperty)
	 */
	@Override
	public TemplateSitePropertyHTMLFormateur<TemplateSiteProperty> getTemplateSitePropertyFormateur(final TemplateSiteProperty property) throws ErreurDonneeNonTrouve {
		final String cleMap = property.getClass().getName();
		final TemplateSitePropertyHTMLFormateur<TemplateSiteProperty> formateur = mapFormateur.get(cleMap);
		if (formateur != null) {
			return formateur;
		} else {
			throw new ErreurDonneeNonTrouve("Impossible de trouver le formateur HTML pour la property : " + cleMap);
		}
	}

	/**
	 * @return the mapExtracteur
	 */
	public Map<String, TemplateSitePropertyExtracteur<TemplateSiteProperty, Object>> getMapExtracteur() {
		return mapExtracteur;
	}

	/**
	 * @return the mapValidateur
	 */
	public Map<String, TemplateSitePropertyValidateur<TemplateSiteProperty>> getMapValidateur() {
		return mapValidateur;
	}

	/**
	 * @return the mapTraitement
	 */
	public Map<String, TemplateSitePropertyTraitement<TemplateSiteProperty>> getMapTraitement() {
		return mapTraitement;
	}

	/**
	 * @return the mapFormateur
	 */
	public Map<String, TemplateSitePropertyHTMLFormateur<TemplateSiteProperty>> getMapFormateur() {
		return mapFormateur;
	}


}
