/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.traitement;

import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;

/**
 * Lancer des traitements extérieurs lié à la propriété et qu'il faut exécuter
 * la sauvegarde d'un {@link InfosSite}.
 * 
 * @author pierre.cosson
 * 
 * @param <T>
 *            Le {@link TemplateSiteProperty} auquel s'applique ce traitement.
 */
public interface TemplateSitePropertyTraitement<T extends TemplateSiteProperty> {

	/**
	 * Traitements liés à une propriété de template.
	 * 
	 * @param infosSite
	 * @param template
	 * @param property
	 * @param data
	 * @throws Exception
	 *             Erreur durant les dtraitements.
	 */
	public void traiter(InfosSiteImpl infosSite, TemplateSite template, T property, InfoBean data) throws Exception;

}
