/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.validateur;

import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.univ.multisites.InfosSite;

/**
 * Valider les données saisies pour une propriété donnée.
 * 
 * @author pierre.cosson
 * 
 * @param <T>
 *            Le {@link TemplateSiteProperty} auquel s'applique ce validateur de
 *            donnée.
 */
public interface TemplateSitePropertyValidateur<T extends TemplateSiteProperty> {

	public static final String MSG_ERREUR_PROPRIETE_OBLIGATOIRE = "La propriété du template '%s' est obligatoire.";

	/**
	 * Valider les données d'une {@link TemplateSiteProperty} saisies et
	 * contenues dans le {@link InfoBean}
	 * 
	 * @param infosSite
	 * @param template
	 * @param property
	 * @param data
	 * @throws Exception
	 *             Une {@link ErreursSaisieInfosSite} est retournée contenant
	 *             toutes les erreurs sur les données de la property.
	 */
	public void valider(InfosSite infosSite, TemplateSite template, T property, InfoBean data) throws Exception;

}
