/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.property.validateur.impl;

import java.util.ArrayList;

import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyColor;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyString;
import com.kosmos.usinesite.template.property.validateur.TemplateSitePropertyValidateur;
import com.kosmos.usinesite.template.utils.TemplateSiteHelper;
import com.univ.multisites.InfosSite;

/**
 * Permet de valider les données d'une {@link TemplateSitePropertyString}
 * 
 * @author pierre.cosson
 * 
 */
public class TemplateSitePropertyColorValidateur extends AbstractTemplateSitePropertyStringValidateur implements TemplateSitePropertyValidateur<TemplateSitePropertyColor> {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kosmos.usinesite.template.validateur.TemplateSitePropertyValidateur
	 * #valider(com.univ.multisites.InfosSite,
	 * com.kosmos.usinesite.template.bean.site.TemplateSite,
	 * com.kosmos.usinesite.template.bean.property.TemplateSiteProperty,
	 * com.jsbsoft.jtf.core.InfoBean)
	 */
	@Override
	public void valider(final InfosSite infosSite, final TemplateSite template, final TemplateSitePropertyColor property, final InfoBean data) throws Exception {
		final String valeur = TemplateSiteHelper.getStringTemplateSiteProperty(template, property, data);
		final ArrayList<String> fluxErreurs = new ArrayList<String>();
		testChampObligatoire(valeur, property, fluxErreurs);
		testTailleMaximum(valeur, property.getTailleMaximum(), property.getLibelle(), fluxErreurs);
		testRegExp(valeur, property.getRegExpValidation(), property.getLibelle(), fluxErreurs);
		testListeValeurs(valeur, property.getListeValeursAutorisees(), property.getLibelle(), fluxErreurs);
		traiterFluxErreurs(fluxErreurs, infosSite, template);
	}
}
