/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.service;

import java.util.List;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.bean.impl.TemplateSiteImpl;

/**
 * Effectuer des opération sur les {@link TemplateSite} de l'application.
 * 
 * @author pierre.cosson
 * 
 */
public interface ServiceTemplateSite {

	/**
	 * Récupérer la liste des {@link TemplateSiteImpl} de l'application.
	 * 
	 * @return La liste des {@link TemplateSite} de l'application
	 */
	public abstract List<TemplateSite> getListeTemplatesSite() throws Exception;

	/**
	 * Récupérer un {@link TemplateSite} via son code (insensible à la casse).
	 * 
	 * @param code
	 *            Code du {@link TemplateSite} à récupérer
	 * @return Le {@link TemplateSite} correspondant au code.
	 * @throws Exception
	 *             <ul>
	 *             <li> {@link ErreurDonneeNonTrouve} : impossible de trouver le {@link TemplateSite} correspondant au code.</li>
	 *             </ul>
	 */
	public abstract TemplateSite getTemplateSiteParCode(String code) throws Exception;

	/**
	 * Récupérer le template de site utilisé par un site.
	 * 
	 * @param codeSite
	 * @throws Exception
	 *             <ul>
	 *             <li> {@link ErreurDonneeNonTrouve} : impossible de trouver le {@link TemplateSite} correspondant au site.</li>
	 *             </ul>
	 */
	public abstract TemplateSite getTemplateSiteParCodeSite(String codeSite) throws Exception;

	/**
	 * Récupérer un template de site via le dossier de JSP qu'il utilisé par ce dernier.
	 * 
	 * @deprecated Cette méthode sert uniquement pour migrer un site déclaré façon 5.1 vers les nouveaux site.
	 * 
	 * @param jspFo
	 *            path du jeu de JSP utilisé par le template (exemple : /jsp)
	 * @return le {@link TemplateSite} utilisant le jeu de JSP
	 * @throws Exception <ul>
	 *            <li> {@link ErreurDonneeNonTrouve} : impossible de trouver le {@link TemplateSite} correspondant au dossier.</li>
	 *            </ul>
	 * 
	 */
	@Deprecated
	public abstract TemplateSite getTemplateSiteParDossier(String jspFo) throws Exception;
}