/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.service;

import com.jsbsoft.jtf.core.ApplicationContextManager;

public class ServiceTemplateSiteFactory {

	public static final String ID_BEAN = "serviceTemplateSiteFactory";

	private ServiceTemplateSite serviceTemplateSiteInstance = null;

	/**
	 * Récupérer le singleton de la factory.
	 * 
	 * @return
	 */
	private static ServiceTemplateSiteFactory getInstance() {
		return (ServiceTemplateSiteFactory) ApplicationContextManager.getCoreContextBean(ID_BEAN);
	}

	public void setServiceTemplateSite(final ServiceTemplateSite serviceTemplateSite) {
		serviceTemplateSiteInstance = serviceTemplateSite;
	}

	/**
	 * Récupérer l'instance de {@link ServiceTemplateSite} de l'application.
	 * 
	 * @return L'instance (singleton).
	 */
	public static ServiceTemplateSite getServiceTemplateSite() {
		return getInstance().serviceTemplateSiteInstance;
	}
}
