/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.service.impl;

import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kdecole.cache.aspect.TempCacheGet;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.service.ServiceTemplateSite;
import com.kportal.core.config.MessageHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.dao.InfosSiteDao;

/**
 * Service permettant de récupérer les {@link TemplateSite} injectés via spring. De plus, ce service met en cache les {@link TemplateSite}.
 *
 * @author pierre.cosson
 *
 */
public class ServiceTemplateSiteImpl implements ServiceTemplateSite {

	/**
	 * Dao utilisé pour récupérer les sauvegarde de site
	 */
	private InfosSiteDao infosSiteDao = null;

	/**
	 * Cache utilisé pour contenir la liste de tous les sites de l'application.
	 */
	private List<TemplateSite> listeTemplatesSite = Collections.<TemplateSite> emptyList();

	public void setListeTemplatesSite(final List<TemplateSite> listeTemplateApplication) {
		listeTemplatesSite = listeTemplateApplication;
	}

	/**
	 * @param infosSiteDao
	 */
	public void setInfosSiteDao(final InfosSiteDao infosSiteDao) {
		this.infosSiteDao = infosSiteDao;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.kosmos.usinesite.service.impl.ServiceTemplateSite#
	 * getListeTemplateSiteApplication()
	 */
	@Override
	public List<TemplateSite> getListeTemplatesSite() throws Exception {
		return listeTemplatesSite;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * com.kosmos.usinesite.service.impl.ServiceTemplateSite#getTemplateSiteParCode
	 * (java.lang.String)
	 */
	@Override
	@TempCacheGet(key = "ServiceTemplateSiteImpl.getTemplateSiteParCode", contextual = false)
	public TemplateSite getTemplateSiteParCode(final String code) throws Exception {
		for (final TemplateSite templateSite : listeTemplatesSite) {
			if (StringUtils.equalsIgnoreCase(templateSite.getCode(), code)) {
				return templateSite;
			}
		}
		throw new ErreurDonneeNonTrouve(MessageHelper.getCoreMessage("BO_USINESITE_ERREUR_AUCUN_TEMPLATE_CODE") + code);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * com.kosmos.usinesite.service.ServiceTemplateSite#getTemplateSiteParCodeSite
	 * (java.lang.String)
	 */
	@Override
	public TemplateSite getTemplateSiteParCodeSite(final String codeSite) throws Exception {
		final InfosSite sauvegarde = infosSiteDao.getInfosSite(codeSite);
		return getTemplateSiteParCode(sauvegarde.getCodeTemplate());
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * com.kosmos.usinesite.service.ServiceTemplateSite#getTemplateSiteParDossier
	 * (java.lang.String)
	 */
	@Override
	@TempCacheGet(key = "ServiceTemplateSiteImpl.getTemplateSiteParDossier", contextual = false)
	public TemplateSite getTemplateSiteParDossier(final String dossierJsp) throws Exception {
		for (final TemplateSite template : getListeTemplatesSite()) {
			if (StringUtils.equalsIgnoreCase(template.getDossierJSP(), dossierJsp)) {
				return template;
			}
		}
		throw new ErreurDonneeNonTrouve("Aucun TemplateSite pour le dossier : " + dossierJsp);
	}
}
