/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.template.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.HtmlUtils;

import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.utils.SaisieInfosSiteInfoBeanHelper;

public class ComposantChoixMultipleInputCheckbox {

	public static final String TAB = "  ";

	public static final String NL = "\n";

	/**
	 * Extraire du {@link InfoBean} la liste des cases cochées sans le composant de liste de textes.
	 * 
	 * @param data
	 *            la source de données.
	 * @param nomComposant
	 *            le nom du composant
	 * @return la liste des clefs des cases à cocher. Liste vide si aucune case cochée
	 */
	public static Collection<String> getListeClefs(final InfoBean data, final List<String> listeClefs) {
		final List<String> out = new ArrayList<String>();
		for (final String clef : listeClefs) {
			if (SaisieInfosSiteInfoBeanHelper.isChecked(data, clef)) {
				out.add(clef);
			}
		}
		return out;
	}

	public static String genererListeCasesACocher(final String nomComposant, final Hashtable<String, String> listeValeurs, final List<String> listeDefaut) {
		final StringBuilder out = new StringBuilder();
		out.append("<ul class=\"liste__horizontale--2 liste__horizontale\" id=\"").append(nomComposant).append("\">");
		final String[] clefs = listeValeurs.keySet().toArray(new String[0]);
		Arrays.sort(clefs);
		for (final String clef : clefs) {
			final String valeur = listeValeurs.get(clef);
			final String id = HtmlUtils.htmlEscape(clef);
			final String checked = listeDefaut.contains(clef) ? " checked=\"checked\"" : StringUtils.EMPTY;
			out.append("<li class=\"liste__horizontale--item\" >");
			out.append("<input type=\"checkbox\" value=\"on\" id=\"").append(id).append("\" name=\"").append(id).append("\"").append(checked).append(" />");
			out.append("<label for=\"").append(id).append("\">").append(valeur).append("</label>");
			out.append("</li>");
		}
		return out.toString();
	}
}
