/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.bean.MediaBean;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.bean.RessourceBean;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Ressource;
import com.univ.utils.ContexteDao;
import com.univ.utils.FileUtil;

public class UASOmHelper {

    /** Logger available to subclasses. */
    protected static final Logger LOGGER = LoggerFactory.getLogger(UASOmHelper.class);

    private static BeanUtilsBean beanUtils;

    static {
        final java.sql.Date defaultValue = null;
        final Converter converter = new DateConverter(defaultValue);
        beanUtils = BeanUtilsBean.getInstance();
        beanUtils.getConvertUtils().register(converter, java.sql.Date.class);
    }

    public static void addAllRessourceMediaBean(final ContexteDao contexteDao, List<RessourceBean> ressources, Map<String, MediaBean> medias, String pathImport) throws Exception {
        // import des ressources
        if (CollectionUtils.isNotEmpty(ressources) && MapUtils.isNotEmpty(medias)) {
            for (final RessourceBean currentRessourceBean : ressources) {
                addRessourceBean(contexteDao, currentRessourceBean);
            }
        }
        // import des médias
        if (MapUtils.isNotEmpty(medias)) {
            for (final MediaBean currentMediaBean : medias.values()) {
                addMediaBean(contexteDao, currentMediaBean, pathImport);
            }
        }
    }

    public static void addAllMediaBean(ContexteDao contexteDao, Map<String, MediaBean> medias, String pathImport) throws Exception {
        if (MapUtils.isNotEmpty(medias)) {
            for (MediaBean currentMediaBean : medias.values()) {
                addMediaBean(contexteDao, currentMediaBean, pathImport);
            }
        }
    }

    public static void addMediaBean(OMContext ctx, MediaBean mediaBean, String pathImport) throws Exception {
        if (mediaBean != null) {
            final Media currentMedia = new Media();
            currentMedia.init();
            currentMedia.setCtx(ctx);
            copyProperties(currentMedia, mediaBean);
            // si le media existe on ne le traite pas
            try {
                currentMedia.retrieve();
                return;
            } catch (Exception e) {
                // nothing
            }
            try {
                if (saveMedia(currentMedia, pathImport)) {
                    currentMedia.add();
                }
            } catch (final Exception e) {
                LOGGER.error("Erreur lors de l'upload du media " + currentMedia.getIdMedia(), e);
            }
        }
    }

    private static boolean saveMedia(Media media, String pathImport) throws IOException {
        boolean save = Boolean.FALSE;
        if (media.isLocal()) {
            final File source = new File(pathImport, media.getUrl());
            if (source.exists()) {
                String destination = MediathequeHelper.getAbsolutePath();
                if (StringUtils.isNotBlank(media.getTypeRessource())) {
                    destination += File.separator + media.getTypeRessource().toLowerCase();
                }
                File file = new File(destination, media.getUrl());
                // si le fichier existe il faut le renommer
                if (file.exists()) {
                    String fileName = media.generateName(FileUtil.getExtension(media.getSource()));
                    media.setUrl(fileName);
                    file = new File(destination, media.getUrl());
                }
                FileUtils.copyFile(source, file);
                save = true;
            }
        } else {
            save = true;
        }
        if (media.getUrlVignette().length() > 0) {
            final File source = new File(pathImport, media.getUrlVignette());
            if (source.exists()) {
                String destination = MediathequeHelper.getAbsolutePath();
                if (media.getTypeRessource().length() > 0) {
                    destination += File.separator + media.getTypeRessource().toLowerCase();
                }
                File file = new File(destination, media.getUrlVignette());
                // si la vignette existe il faut la renommer
                if (file.exists()) {
                    media.setUrlVignette("v_" + media.getUrl());
                    file = new File(destination, media.getUrlVignette());
                }
                FileUtils.copyFile(source, file);
            } else {
                media.setUrlVignette("");
            }
        }
        return save;
    }

    public static void addRessourceBean(OMContext ctx, RessourceBean ressourceBean) throws Exception {
        if (ressourceBean != null) {
            final Ressource currentRessource = new Ressource();
            currentRessource.init();
            copyProperties(currentRessource, ressourceBean);
            currentRessource.setCtx(ctx);
            currentRessource.add();
        }
    }

    public static void addMetatagBean(OMContext ctx, MetatagBean metaTagBean) throws Exception {
        if (metaTagBean != null) {
            final Metatag metaTag = new Metatag();
            metaTag.init();
            copyProperties(metaTag, metaTagBean);
            metaTag.setCtx(ctx);
            metaTag.add();
        }
    }

    public static void copyProperties(Object object1, Object object2) throws IllegalAccessException, InvocationTargetException {
        beanUtils.copyProperties(object1, object2);
    }
}
