/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.validation.exception;

import java.util.HashSet;
import java.util.Set;

import javax.validation.ConstraintViolation;

import com.jsbsoft.jtf.exception.ErreurApplicative;

/**
 * Exception pouvant être lever lors de la validation d'un bean.
 */
public class ConstraintValidationException extends ErreurApplicative {

	private Set<ConstraintViolation<?>> constraintViolations = new HashSet<>();

	public ConstraintValidationException(String mes,Set<? extends ConstraintViolation<?>> constraintViolations) {
		super(mes);
		this.constraintViolations =  new HashSet<>(constraintViolations);
	}

	public ConstraintValidationException(int num, String mes) {
		super(num, mes);
	}

	public ConstraintValidationException(String mes, Throwable t) {
		super(mes, t);
	}

	public ConstraintValidationException(String mes) {
		super(mes);
	}

	public Set<ConstraintViolation<?>> getConstraintViolations() {
		return constraintViolations;
	}

}
