/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.validation.message;

import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

import java.util.Locale;

/**
 * Created by olivier.camon on 22/12/14.
 */
public class LocaleMessageInterpolator extends ResourceBundleMessageInterpolator {

	private final Locale defaultLocale;

    public LocaleMessageInterpolator(Locale locale, ResourceBundleLocator userResourceBundleLocator) {
        super(userResourceBundleLocator);
        this.defaultLocale = locale;
    }

    public LocaleMessageInterpolator(Locale locale) {
		this.defaultLocale = locale;
	}

	@Override
	public String interpolate(String messageTemplate, Context context) {
		return super.interpolate(messageTemplate, context, this.defaultLocale);
	}

	@Override
	public String interpolate(String messageTemplate, Context context, Locale locale) {
		return super.interpolate(messageTemplate, context, locale);
	}
}
