/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.validation.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.kosmos.validation.constraint.NotDefaultValue;
import org.apache.commons.lang3.StringUtils;

/**
 * Validateur servant à vérifier qu'un champ ne correspond pas à la valeur par défaut de kportal/ksup.
 * À savoir non vide et != 0000
 */
public class NotDefaultValueValidator implements ConstraintValidator<NotDefaultValue,String> {

	@Override
	public void initialize(NotDefaultValue constraintAnnotation) {
	}

	@Override
	public boolean isValid(String value, ConstraintValidatorContext context) {
		return StringUtils.isNotBlank(value) && !"0000".equals(value);
	}
}
