/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.validation.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.kosmos.validation.constraint.PasswordSize;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.processus.MotDePasseCtrl;
import org.apache.commons.lang3.StringUtils;

/**
 * Validateur servant à valider qu'un champ password correspond au valeur défini dans les properties de l'application.
 */
public class PasswordValidator implements ConstraintValidator<PasswordSize,String> {

	@Override
	public void initialize(PasswordSize constraintAnnotation) {
	}

	@Override
	public boolean isValid(String value, ConstraintValidatorContext context) {
		boolean isValid = Boolean.FALSE;
		if (StringUtils.isNotEmpty(value)) {
			final int min = PropertyHelper.getCorePropertyAsInt("utilisateur.password.longueur.min", 0);
			final int max = PropertyHelper.getCorePropertyAsInt("utilisateur.password.longueur.max", MotDePasseCtrl.LONGUEUR_MOT_DE_PASSE_DEFAUT);
			isValid = value.length() >= min && value.length() <= max;
		}
		return isValid;
	}
}
