/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public abstract class AbstractCacheManager {

	private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheManager.class);

	@Async
	public void asyncRefresh() {
		refresh();
	}

	public void refresh() {
		try {
			if (!CacheUtil.updateObjectValue(getCacheName(), getObjectKey(), getObjectToCache())) {
				throw new Exception();
			}
		} catch (final Exception e) {
			LOGGER.error("Erreur refresh du cache " + getCacheName(), e);
		}
	}

	public Object call() {
		return CacheUtil.getObjectValue(getCacheName(), getObjectKey());
	}

	public void flush() {
		if (!CacheUtil.flush(getCacheName(), getObjectKey())) {
			LOGGER.error("Erreur flush du cache " + getCacheName());
		}
	}

	public abstract Object getObjectToCache() throws Exception;

	public abstract String getCacheName();

	public abstract Object getObjectKey();
}
