/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.cache;

import java.util.Observable;
import java.util.Observer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kportal.extension.ExtensionManager;
import com.univ.objetspartages.cache.CacheGroupeDsiManager;
import com.univ.objetspartages.cache.CacheInfosSiteManager;
import com.univ.objetspartages.cache.CacheLibelleManager;
import com.univ.objetspartages.cache.CacheProfilDsiManager;
import com.univ.objetspartages.cache.CacheRoleManager;
import com.univ.objetspartages.cache.CacheRubriqueManager;
import com.univ.objetspartages.cache.CacheServiceManager;

/*
 * Cette classe permet de charger les caches applicatifs au démarrage de tomcat une fois l'application initialisée
 * Tous les caches ne sont pas présents ici car d'autre Bean Manager charge également les caches. cf PageAccueilRubriqueManager qui gere les urls de rubrique
 */
public class CacheLoaderManager extends Observable implements Observer {

	private static final Logger LOGGER = LoggerFactory.getLogger(CacheLoaderManager.class);

	public CacheProfilDsiManager cacheProfilDsiManager;

	public CacheRoleManager cacheRoleManager;

	public CacheGroupeDsiManager cacheGroupeDsiManager;

	public CacheLibelleManager cacheLibelleManager;

	public CacheInfosSiteManager cacheInfosSiteManager;

	public CacheRubriqueManager cacheRubriqueManager;

	public CacheServiceManager cacheServiceManager;

	public ExtensionManager extensionManager;

	public void init() {
		extensionManager.addObserver(this);
	}

	public void refresh() {

		// rechargement des rubriques
		cacheRubriqueManager.refresh();

		// rechargement des sites
		cacheInfosSiteManager.refresh();

		// rechargement des services
		cacheServiceManager.refresh();

		// rechargement des libelles
		try {
			cacheLibelleManager.flushAll();
			cacheLibelleManager.getListeInfosLibelles();
			cacheLibelleManager.getListeTypesLibelles();
		} catch (final Exception e) {
			LOGGER.error(e.getMessage(), e);
		}
		// rechargement des groupes
		try {
			cacheGroupeDsiManager.flush();
			cacheGroupeDsiManager.getListeGroupesDsi();
			cacheGroupeDsiManager.getListeRequetesGroupes();
		} catch (final Exception e) {
			LOGGER.error(e.getMessage(), e);
		}
		// rechargement des rôles
		try {
			cacheRoleManager.flush();
			cacheRoleManager.getListeRoles();
		} catch (final Exception e) {
			LOGGER.error(e.getMessage(), e);
		}
		// rechargement des profils
		try {
			cacheProfilDsiManager.flush();
			cacheProfilDsiManager.getListeProfilsDsi();
		} catch (final Exception e) {
			LOGGER.error(e.getMessage(), e);
		}
	}

	public void setCacheProfilDsiManager(final CacheProfilDsiManager cacheProfilDsiManager) {
		this.cacheProfilDsiManager = cacheProfilDsiManager;
	}

	public void setCacheRoleManager(final CacheRoleManager cacheRoleManager) {
		this.cacheRoleManager = cacheRoleManager;
	}

	public void setCacheGroupeDsiManager(final CacheGroupeDsiManager cacheGroupeDsiManager) {
		this.cacheGroupeDsiManager = cacheGroupeDsiManager;
	}

	public void setCacheLibelleManager(final CacheLibelleManager cacheLibelleManager) {
		this.cacheLibelleManager = cacheLibelleManager;
	}

	public void setCacheInfosSiteManager(final CacheInfosSiteManager cacheInfosSiteManager) {
		this.cacheInfosSiteManager = cacheInfosSiteManager;
	}

	public void setCacheRubriqueManager(final CacheRubriqueManager cacheRubriqueManager) {
		this.cacheRubriqueManager = cacheRubriqueManager;
	}

	public void setCacheServiceManager(CacheServiceManager cacheServiceManager) {
		this.cacheServiceManager = cacheServiceManager;
	}

	@Override
	public void update(Observable o, Object arg) {
		refresh();
		setChanged();
		notifyObservers();
	}

	public void setExtensionManager(ExtensionManager extensionManager) {
		this.extensionManager = extensionManager;
	}
}
