/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.cache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

import com.jsbsoft.jtf.core.ApplicationContextManager;

public class CacheUtil {

	/** The Constant ID_BEAN. */
	public static final String ID_BEAN = "cacheManager";

	public static CacheManager getCacheManager() {
		return (CacheManager) ApplicationContextManager.getCoreContextBean(ID_BEAN);
	}

	public static void flushCache(final String cacheName) {
		final CacheManager cacheMgr = getCacheManager();
		if (cacheMgr != null && cacheMgr.getCache(cacheName) != null) {
			cacheMgr.getCache(cacheName).removeAll();
		}
	}

	public static Object getObjectValue(final String cacheName, final Object keyValue) {
		final CacheManager cacheMgr = getCacheManager();
		if (cacheMgr != null && cacheMgr.getCache(cacheName) != null && cacheMgr.getCache(cacheName).get(keyValue) != null) {
			return cacheMgr.getCache(cacheName).get(keyValue).getObjectValue();
		}
		return null;
	}

	public static boolean updateObjectValue(final String cacheName, final Object keyValue, final Object value) {
		final CacheManager cacheMgr = getCacheManager();
		if (cacheMgr != null) {
			cacheMgr.addCacheIfAbsent(cacheName);
			cacheMgr.getCache(cacheName).put(new Element(keyValue, value));
			return true;
		}
		return false;
	}

	public static boolean flush(final String cacheName, final Object objectKey) {
		final CacheManager cacheMgr = getCacheManager();
		if (cacheMgr != null && cacheMgr.getCache(cacheName) != null) {
			cacheMgr.getCache(cacheName).remove(objectKey);
			return true;
		}
		return false;
	}
}
