/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.captcha.component.word;

import java.util.Locale;
import java.util.StringTokenizer;

import com.kportal.core.config.PropertyHelper;
import com.octo.captcha.component.word.DefaultSizeSortedWordList;
import com.octo.captcha.component.word.DictionaryReader;
import com.octo.captcha.component.word.SizeSortedWordList;

/**
 * <p>
 * Implementation of the DictionaryReader interface, uses a .properties file to retrieve words and return a WordList.Constructed with the name of the properties file. It uses
 * standard java mecanism for I18N
 * </p>
 * 
 * @author <a href="mailto:mga@octo.com">Mathieu Gandin</a>
 * @version 1.1
 */
public class FileDictionary implements DictionaryReader {

	private final String property;

	public FileDictionary(final String property) {
		this.property = property;
	}

	@Override
	public SizeSortedWordList getWordList() {
		final SizeSortedWordList list = generateWordList(Locale.getDefault(), property);
		return list;
	}

	@Override
	public SizeSortedWordList getWordList(final Locale locale) {
		final SizeSortedWordList list = generateWordList(locale, property);
		return list;
	}

	protected SizeSortedWordList generateWordList(final Locale locale, final String property) {
		final DefaultSizeSortedWordList list = new DefaultSizeSortedWordList(locale);
		final StringTokenizer tokenizer = new StringTokenizer(PropertyHelper.getCoreProperty(property), ";");
		final int count = tokenizer.countTokens();
		for (int i = 0; i < count; i++) {
			list.addWord(tokenizer.nextToken());
		}
		return list;
	}
}
