/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.captcha.image;

import java.awt.image.BufferedImage;
import java.io.Serializable;

import com.octo.captcha.image.ImageCaptcha;

/**
 * <p>
 * A Gimpy is an ImageCaptcha. It is also the most common captcha.
 * </p>
 * <ul>
 * <li>Challenge type : image</li>
 * <li>Response type : String</li>
 * <li>Description : An image of a distorded word is shown. User have to recognize the word and to submit it.</li>
 * </ul>
 *
 * @author <a href="mailto:mag@jcaptcha.net">Marc-Antoine Garrigue</a>
 * @version 1.0
 */
public class Gimpy extends ImageCaptcha implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 1506331973116957259L;

	private final String response;

	Gimpy(final String question, final BufferedImage challenge, final String response) {
		super(question, challenge);
		this.response = response;
	}

	/**
	 * Validation routine from the CAPTCHA interface. this methods verify if the response is not null and a String and then compares the given response to the internal string.
	 *
	 * @return true if the given response equals the internal response, false otherwise.
	 */
	@Override
	public final Boolean validateResponse(final Object response) {
		return (null != response && response instanceof String) ? validateResponse((String) response) : Boolean.FALSE;
	}

	/**
	 * Very simple validation routine that compares the given response to the internal string.
	 *
	 * @return true if the given response equals the internal response, false otherwise.
	 */
	private final Boolean validateResponse(final String response) {
		return Boolean.valueOf(response.equals(this.response));
	}

	public String getResponse() {
		return response;
	}
}
