/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.cms.mail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.extension.module.AbstractBeanManager;

public class MailFormaterManager extends AbstractBeanManager{

	public static final String ID_BEAN = "mailFormaterManager";

	public Map<String,List<MailNotificationFormater>> formaters;

	public List<MailNotificationFormater> defaultFormaters;

	public List<MailNotificationFormater> getFormaters(String classe){
		if (formaters.get(classe)!=null){
			return formaters.get(classe);
		}else{
			return defaultFormaters;
		}
	}

	@Override
	public void refresh() {
		Map<String,List<MailNotificationFormater>> tmpMap = new HashMap<>();
		List<MailNotificationFormater> tmpList = new ArrayList<>();
		final Collection<MailNotificationFormater> beans = ApplicationContextManager.getAllBeansOfType(MailNotificationFormater.class).values();
		for (final MailNotificationFormater formater : beans) {
			if (formater.getClasses()!=null){
				for (String classe : formater.getClasses()) {
					if(tmpMap.get(classe)==null){
						List<MailNotificationFormater> l = new ArrayList<>();
						tmpMap.put(classe, l);
					}
					tmpMap.get(classe).add(formater);
				}
			}
			else{
				tmpList.add(formater);
			}
		}
		formaters = tmpMap;
		defaultFormaters = tmpList;
	}


	public Map<String, List<MailNotificationFormater>> getFormaters() {
		return formaters;
	}


	public void setFormaters(Map<String, List<MailNotificationFormater>> formaters) {
		this.formaters = formaters;
	}


	public List<MailNotificationFormater> getDefaultFormaters() {
		return defaultFormaters;
	}


	public void setDefaultFormaters(List<MailNotificationFormater> defaultFormaters) {
		this.defaultFormaters = defaultFormaters;
	}


}
