/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.cms.objetspartages;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.jsbsoft.jtf.core.ClassBeanManager;
import com.jsbsoft.jtf.core.CodeLibelle;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginRechercheHelper;
import com.univ.objetspartages.om.RechercheExterne;
import com.univ.objetspartages.om.ReferentielObjets;

public class ObjetPartageHelper {

	private static final String FICHE = "fiche";

	private static final String STYLE = "STYLE";

	private static final String STYLE_AFFICHAGE = "style_affichage";

	public static final String TEMPLATE_FICHE = FICHE;

	public static final String TEMPLATE_ENTETE_FICHE = "entete_fiche";

	public static final String TEMPLATE_SAISIE = "saisie";

	public static final String TEMPLATE_ENCADRE_RECHERCHE = "encadre_recherche";

	public static final String TEMPLATE_ENCADRE_AUTOFICHE = "encadre_fiche";

	public static final String TEMPLATE_REQUETE_RESULTAT = "requete_resultat";

	public static final String TEMPLATE_RECHERCHE_CALCUL = "recherche_calcul";

	public static final String TEMPLATE_RECHERCHE_RESULTAT = "recherche_resultat";

	public static final String TEMPLATE_RECHERCHE = "recherche";

	public static final String PATH_TEMPLATE_REQUETE_RESULTAT_DEFAULT = "default";

	public static String getTemplateObjet(final String templateJsp, final String objet) {
		String path = "";
		final Objetpartage op = ReferentielObjets.getObjetByNom(objet);
		IExtension extension = null;
		if (op != null) {
			extension = ModuleHelper.getExtensionModule(op);
		} else if (objet.equals(PATH_TEMPLATE_REQUETE_RESULTAT_DEFAULT)) {
			extension = ExtensionHelper.getCoreExtension();
		}
		if (extension != null) {
			path = ExtensionHelper.PATH_WEB_INF_JSP + "/" + objet + ExtensionHelper.PATH_FO + "/" + templateJsp + ExtensionHelper.EXTENSION_TEMPLATE;
			return ExtensionHelper.getTemplateExtension(extension.getId(), path, Boolean.TRUE);
		}
		return path;
	}

	// Renvoie la liste des styles d'affichage pour l'extension de l'objet en paramètre
	public static Map<String, String> getStylesAffichage(final String objet) {
		final Objetpartage op = ReferentielObjets.getObjetByNom(objet);
		return CodeLibelle.lireTable(op.getIdExtension(), objet.toLowerCase() + "_" + STYLE_AFFICHAGE, null);
	}

	public static List<String> getCriteresRequete(final String objet, final boolean listeIncluse) {
		final Objetpartage op = ReferentielObjets.getObjetByNom(objet);
		List<String> criteres = new ArrayList<>();
		for (final RechercheExterne bean : ClassBeanManager.getInstance().getBeanOfType(RechercheExterne.class)) {
			// critères métiers propres à chaque objet
			criteres = bean.getCriteresRequete(objet.toUpperCase(), listeIncluse);
			if (criteres.size() > 0) {
				break;
			}
		}
		if (listeIncluse) {
			// critères de style sur l'objet
			if ("1".equals(PropertyHelper.getProperty(op.getIdExtension(), FICHE + "." + objet.toUpperCase() + "." + STYLE_AFFICHAGE))) {
				criteres.add(STYLE);
			}
			// critères des plugins de recherche activés sur l'objet
			criteres.addAll(PluginRechercheHelper.getCriteresRequete(objet));
		}
		// Ajout des critères communs
		criteres.add("CODE_RUBRIQUE");
		criteres.add("CODE_RATTACHEMENT");
		// NB : certains critères sont automatiquement parsés dans le fichier js : recherche.js
		// GROUPE_DSI, LANGUE, NOMBRE
		return criteres;
	}
}
