/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.cms.objetspartages.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * The Class GetterAnnotationHelper.
 */
public class GetterAnnotationHelper {

	/**
	 * teste la présense de l'annotation getterAnnotation et si la méthode set un contenu de toolbox.
	 * 
	 * @param getterMethod
	 *            the getter method
	 * @return true, if is toolbox
	 */
	public static boolean isToolbox(Method getterMethod) {
		GetterAnnotation getterAnnotation = getterMethod.getAnnotation(GetterAnnotation.class);
		return (getterAnnotation != null && getterAnnotation.isToolbox());
	}

	/**
	 * Renvoit la liste des méthodes d'une fiche correspondant à des getter de contenu toolbox.
	 * 
	 * @param objet
	 *            the fiche univ
	 * @return the liste toolbox
	 */
	public static List<Method> getMethodToolbox(Object objet) {
		ArrayList<Method> liste = new ArrayList<Method>();
		for (Method method : objet.getClass().getMethods()) {
			if (isToolbox(method)) {
				liste.add(method);
			}
		}
		return liste;
	}

	/**
	 * teste la présense de l'annotation getterAnnotation et si la méthode set un contenu de toolbox.
	 * 
	 * @param getterMethod
	 *            the getter method
	 * @return true, if is toolbox
	 */
	public static boolean isIdMedia(Method getterMethod) {
		GetterAnnotation getterAnnotation = getterMethod.getAnnotation(GetterAnnotation.class);
		return (getterAnnotation != null && getterAnnotation.isIdMedia());
	}

	/**
	 * Renvoit la liste des méthodes d'une fiche correspondant à des getter d'id media.
	 * 
	 * @param objet
	 *            the fiche univ
	 * @return the liste toolbox
	 */
	public static List<Method> getMethodIdMedia(Object objet) {
		ArrayList<Method> liste = new ArrayList<Method>();
		for (Method method : objet.getClass().getMethods()) {
			if (isIdMedia(method)) {
				liste.add(method);
			}
		}
		return liste;
	}
}
