/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.cms.objetspartages.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import com.univ.objetspartages.om.FicheUniv;

/**
 * The Class GetterAnnotationHelper.
 */
public class SetterAnnotationHelper {

	/**
	 * teste la présense de l'annotation SetterAnnotation et si la méthode set un contenu de toolbox.
	 * 
	 * @param setterMethod
	 *            the setter method
	 * @return true, if is toolbox
	 */
	public static boolean isToolbox(Method setterMethod) {
		SetterAnnotation setterAnnotation = setterMethod.getAnnotation(SetterAnnotation.class);
		return (setterAnnotation != null && setterAnnotation.isToolbox());
	}

	/**
	 * Renvoit la liste des méthodes d'une fiche correspondant à des setter de contenu toolbox.
	 * 
	 * @param ficheUniv
	 *            the fiche univ
	 * @return the liste toolbox
	 */
	public static List<Method> getMethodToolbox(FicheUniv ficheUniv) {
		ArrayList<Method> liste = new ArrayList<Method>();
		for (Method method : ficheUniv.getClass().getMethods()) {
			if (isToolbox(method)) {
				liste.add(method);
			}
		}
		return liste;
	}
}
