/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.cms.objetspartages.oi;

import com.univ.objetspartages.om.AnnuaireModele;
import com.univ.objetspartages.om.FicheUniv;

/**
 * Classe renvoyant le libelle mailto et l'adresse mail d'une fiche annuaire
 *
 * @author yacouba.kone
 *
 */
public class AnnuaireModeleMail implements ObjetMail {

	/**
	 * Renvoie le nom de la personne à qui on envoie l'email.
	 *
	 * @return the libelle mailto
	 */
	@Override
	public String getLibelle(final FicheUniv ficheUniv) {
		return ((AnnuaireModele) ficheUniv).getLibelleAffichable();
	}

	/**
	 * Renvoie l'email de la personne à qui on écrit.
	 *
	 * @return the mailto
	 */
	@Override
	public String getAdresse(final FicheUniv ficheUniv) {
		return ((AnnuaireModele) ficheUniv).getAdresseMail();
	}
}
