/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core;

import java.io.IOException;
import java.net.URLEncoder;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.lang.CharEncoding;
import com.univ.multisites.InfosSite;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;

/**
 */
public class ErrorServlet extends HttpServlet {

	/**
	 * ID Serialisation
	 */
	private static final long serialVersionUID = 6792391717404684763L;

	private static final Logger LOG = LoggerFactory.getLogger(ErrorServlet.class);

	private static final String CONTENT_TYPE = "text/html";

	@Override
	public void doGet(final HttpServletRequest servletRequest, final HttpServletResponse servletResponse) throws IOException, ServletException {
		servletResponse.setContentType(CONTENT_TYPE);
		try {
			final ContexteUniv ctx = ContexteUtil.getContexteUniv();
			final int code = NumberUtils.toInt(servletRequest.getParameter("CODE"), HttpServletResponse.SC_NOT_FOUND);
			String urlDemandee = StringUtils.EMPTY;
			final Object requestURI = servletRequest.getAttribute("javax.servlet.forward.request_uri");
			if (requestURI != null) {
				urlDemandee = requestURI.toString();
			}
			final Object queryString = servletRequest.getAttribute("javax.servlet.forward.query_string");
			if (queryString != null && StringUtils.isNotEmpty(urlDemandee)) {
				urlDemandee += "?" + queryString.toString();
			}
			final String referer = servletRequest.getHeader("referer");
			// on ne forwarde que les pages, pas les images introuvables par ex.
			if (referer == null || referer.contains(urlDemandee)) {
                LOG.error("Page introuvable : " + URLResolver.getAbsoluteUrl(urlDemandee, ctx));
                servletResponse.setStatus(code);
				final InfosSite siteCourant = ctx.getInfosSite();
				final String urlRelativeJspError = siteCourant.getJspFo() + "/error/" + code + ".jsp?URL_DEMANDEE=" + URLEncoder.encode(urlDemandee, CharEncoding.DEFAULT);
				//String urlRelativeJspErrorcontextuelle = URLResolver.getRelativeURLContextuelle(siteCourant, urlRelativeJspError);
				final javax.servlet.RequestDispatcher rd = getServletConfig().getServletContext().getRequestDispatcher(urlRelativeJspError);
				rd.forward(servletRequest, servletResponse);
			} else {
				LOG.error("Contenu introuvable : " + urlDemandee);
			}
		} catch (final Exception e) {
			LOG.error(e.getMessage(), e);
		}
	}

	@Override
	public void doPost(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
		doGet(request, response);
	}
}
