/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.autorisation.util;

import java.util.ArrayList;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;

import com.kportal.core.autorisation.ActionPermission;
import com.kportal.core.autorisation.Permission;
import com.kportal.extension.module.IModule;
import com.univ.objetspartages.om.PermissionBean;

public class PermissionUtil {

	/**
	 * Retourne la permission {@link PermissionBean} à partir d'un module {@link IModule} d'un code de permission et d'un code d'action
	 */
	public static PermissionBean getPermissionBean(final IModule module, final String codePermission, final String codeAction) {
		if (module != null) {
			for (final Permission permission : module.getPermissions()) {
				if (permission.getCode().equals(codePermission)) {
					for (final ActionPermission action : permission.getActions()) {
						if (action.getCode().equals(codeAction)) {
							return getPermissionBean(permission, action);
						}
					}
				}
			}
		}
		return null;
	}

	/**
	 * Construit un {@link PermissionBean} à partir d'un {@link Permission} et d'un {@link ActionPermission} Un {@link Permission} peut contenir N action, alors qu'un
	 * {@link PermissionBean} en contient qu'une seule. Il faut donc préciser l'action pour pouvoir créer un {@link PermissionBean}
	 * 
	 * @param permission
	 * @param action
	 * @return
	 */
	public static PermissionBean getPermissionBean(final Permission permission, final ActionPermission action) {
		return new PermissionBean(StringUtils.upperCase(permission.getId()), permission.getCode(), action.getCode());
	}

	/**
	 * Retourne les {@link PermissionBean} disponible a partir d'un objet Permission.
	 * 
	 * @param permission
	 * @return
	 */
	public static Collection<PermissionBean> getPermissionsBeans(final Permission permission) {
		final Collection<PermissionBean> permissions = new ArrayList<>();
		for (final ActionPermission action : permission.getActions()) {
			permissions.add(getPermissionBean(permission, action));
		}
		return permissions;
	}
}
