/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.cluster;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import fr.kosmos.cluster.api.MessageHandler;

public class ClusterHelper {

	/**
	 * Retourne le singleton
	 * @return ClusterManager
	 */
	public static ClusterManager getClusterManager() {
		return ClusterManager.getInstance();
	}

	/**
	 * Retourne la propiété jvmRoute du cluster courant
	 * @return la jvmRoute courante
	 */
	public static String getCurrentJvmRoute() {
		if (getClusterManager().getCluster().getMembers().size()>1){
			return getClusterManager().getCluster().getName();
		}
		return StringUtils.EMPTY;
	}

	/**
	 * Execute un rafraichissement du singleton via la méthode handleMessage sur le noeud courant
	 * puis envoie un message aux autres noeuds
	 * @param service le singleton
	 * @param message le message
	 */
	public static void refresh(MessageHandler<Serializable>service, Serializable message){
		service.handleMessage(message);
		getClusterManager().getCluster().sendMessage(service.getClass(), message);
	}
}
