/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The Class LangueConfig.
 */
public class LangueConfig {

	/** Logger */
	private static final Logger LOGGER = LoggerFactory.getLogger(LangueConfig.class);

	/** The Constant ID_BEAN. */
	public static final String ID_BEAN = "langueConfig";

	/** The Constant DEFAULT_PATH. */
	public static final String DEFAULT_PATH = "/adminsite/images/langues/";

	/** The Constant DEFAULT_IMAGE_DRAPEAU. */
	public static final String DEFAULT_IMAGE_DRAPEAU = "drapeau.png";

	public int max_langue = 10;

	/** The locales. */
	private Map<Integer, Langue> langues = null;

	/** The locale bo. */
	private int indiceLangueBo = 0;

	/**
	 * Initialisation à partir du fichier paramètre.
	 *
	 */
	public void init() {
		try {
			try {
				max_langue = Integer.parseInt(PropertyConfigurer.getProperty("application.max_langue"));
			} catch (final Exception e) {}
			langues = new HashMap<>();
			for (int i = 0; i < max_langue; i++) {
				final String language = PropertyConfigurer.getProperty("langue_" + i + ".language");
				if (StringUtils.isEmpty(language)) {
					continue;
				}
				final String country = StringUtils.defaultIfEmpty(PropertyConfigurer.getProperty("langue_" + i + ".country"), "");
				final String url = StringUtils.defaultIfEmpty(PropertyConfigurer.getProperty("langue_" + i + ".url"), DEFAULT_PATH + language);
				final Langue lb = new Langue(i, new Locale(language, country), url);
				langues.put(i, lb);
			}
			try {
				indiceLangueBo = Integer.parseInt(PropertyConfigurer.getProperty("application.langue_bo"));
			} catch (final Exception e) {}
		} catch (final Exception e) {
			LOGGER.error("Erreur dans l'initialisation des langues de l'application : vérifier la configuration", e);
		}
	}

	/**
	 * Gets the nb langues.
	 *
	 * @return the nb langues
	 */
	public int getNbLangues() {
		return langues.size();
	}

	public Map<Integer, Langue> getLangues() {
		return langues;
	}

	public int getIndiceLangueBo() {
		return indiceLangueBo;
	}
}
