/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.config;

import java.util.Locale;
import java.util.Properties;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.ApplicationContextManager;

public class MessageLoaderUtil {

	public static String getMessage(String idCtx, final String langue, final String key) {
		if (StringUtils.isEmpty(idCtx)) {
			idCtx = ApplicationContextManager.DEFAULT_CORE_CONTEXT;
		}
		for (final MessageLoader loader : ApplicationContextManager.getBeansOfType(idCtx, MessageLoader.class).values()) {
			if (loader.getProperties(langue) != null) {
				final String message = loader.getProperties(langue).getProperty(key);
				if (message != null) {
					// le helper permet de substituer la valeur d'une propriété ${key} par la valeur de 'key'
					return loader.getPlaceHolderHelper().replacePlaceholders(message, loader.getProperties(langue));
				}
			}
		}
		return StringUtils.EMPTY;
	}

	public static Properties getMessages(String idCtx, final Locale locale) {
		if (StringUtils.isEmpty(idCtx)) {
			idCtx = ApplicationContextManager.DEFAULT_CORE_CONTEXT;
		}
		final Properties prop = new Properties();
		for (final MessageLoader loader : ApplicationContextManager.getBeansOfType(idCtx, MessageLoader.class).values()) {
			String langue = locale.getLanguage();
			if (StringUtils.isNotEmpty(locale.getCountry())) {
				langue += "_" + locale.getCountry();
			}
			if (loader.getProperties(langue) != null) {
				prop.putAll(loader.getProperties(langue));
			}
		}
		return prop;
	}
}
