/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.config;

import java.io.IOException;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.extension.ExtensionHelper;

public class PropertyConfigurerManager {

	public static synchronized void reload() throws IOException {
		// on boucle sur toutes les extensions chargees
		for (final String contextName : ExtensionHelper.getExtensionManager().getExtensions().keySet()) {
			for (final PropertyConfigurer propertyConfigurer : ApplicationContextManager.getBeansOfType(contextName, PropertyConfigurer.class).values()) {
				propertyConfigurer.reload();
			}
		}
	}

	public static synchronized void reloadByContext(final String contextName) throws IOException {
		// on verifie que l'extension est bien chargee
		if (ExtensionHelper.getExtensionManager().getExtension(contextName) != null) {
			for (final PropertyConfigurer propertyConfigurer : ApplicationContextManager.getBeansOfType(contextName, PropertyConfigurer.class).values()) {
				propertyConfigurer.reload();
			}
		}
	}
}
