/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.config;

import java.util.Properties;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.ApplicationContextManager;

public class PropertyConfigurerUtil {

	public static String getProperty(final String key) {
		return getProperty(ApplicationContextManager.DEFAULT_CORE_CONTEXT, key);
	}

	public static String getProperty(String idCtx, final String key) {
		if (StringUtils.isEmpty(idCtx)) {
			idCtx = ApplicationContextManager.DEFAULT_CORE_CONTEXT;
		}
		for (final PropertyConfigurer loader : ApplicationContextManager.getBeansOfType(idCtx, PropertyConfigurer.class).values()) {
			final String message = loader.getProperties().getProperty(key);
			if (message != null) {
				// le helper permet de substituer la valeur d'une propriété ${key} par la valeur de 'key'
				return loader.getPlaceHolderHelper().replacePlaceholders(message, loader.getProperties());
			}
		}
		return null;
	}

	public static Properties getProperties(String idCtx) {
		if (StringUtils.isEmpty(idCtx)) {
			idCtx = ApplicationContextManager.DEFAULT_CORE_CONTEXT;
		}
		final Properties prop = new Properties();
		for (final PropertyConfigurer loader : ApplicationContextManager.getBeansOfType(idCtx, PropertyConfigurer.class).values()) {
			prop.putAll(loader.getProperties());
		}
		return prop;
	}
}
