/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.context;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import com.jsbsoft.jtf.core.ApplicationContextManager;

public class AttributeToOverrideBean implements MergedContextBean {

	boolean mandatory = false;

	String idBeanToMerge = "";

	String idExtensionToMerge = "";

	Map<String, Object> attributes = new HashMap<>();

	@Override
	public boolean isMandatory() {
		return mandatory;
	}

	public void setMandatory(final boolean mandatory) {
		this.mandatory = mandatory;
	}

	@Override
	public String getIdBeanToMerge() {
		return idBeanToMerge;
	}

	@Override
	public void setIdBeanToMerge(final String idBeanToMerge) {
		this.idBeanToMerge = idBeanToMerge;
	}

	@Override
	public String getIdExtensionToMerge() {
		return idExtensionToMerge;
	}

	@Override
	public void setIdExtensionToMerge(final String idExtensionToMerge) {
		this.idExtensionToMerge = idExtensionToMerge;
	}

	public Map<String, Object> getAttributes() {
		return attributes;
	}

	public void setAttributes(final Map<String, Object> attributes) {
		this.attributes = attributes;
	}

	@Override
	public void merge() throws Exception {
		final Object bean = ApplicationContextManager.getBean(idExtensionToMerge, idBeanToMerge);
		for (final String setter : attributes.keySet()) {
			final String methodName = "set" + setter.substring(0, 1).toUpperCase() + setter.substring(1);
			final Object args[] = { attributes.get(setter) };
			// recherche de la méthode sur la classe
			for (final Method m : bean.getClass().getMethods()) {
				if (m.getName().equals(methodName)) {
					m.invoke(bean, args);
					break;
				}
			}
		}
	}
}
