/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.context;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import com.jsbsoft.jtf.core.ApplicationContextManager;

public class MapToAddBean implements MergedContextBean {

	boolean mandatory = false;

	String idBeanToMerge = "";

	String idExtensionToMerge = "";

	String mapToMerge = "";

	Map<Object, Object> add = new HashMap<>();

	@Override
	public String getIdBeanToMerge() {
		return idBeanToMerge;
	}

	@Override
	public void setIdBeanToMerge(final String idBeanToMerge) {
		this.idBeanToMerge = idBeanToMerge;
	}

	@Override
	public String getIdExtensionToMerge() {
		return idExtensionToMerge;
	}

	@Override
	public void setIdExtensionToMerge(final String idExtensionToMerge) {
		this.idExtensionToMerge = idExtensionToMerge;
	}

	@Override
	public void merge() throws Exception {
		getMap().putAll(add);
	}

	public void setAdd(final Map<Object, Object> add) {
		this.add = add;
	}

	@SuppressWarnings("unchecked")
	private Map<Object, Object> getMap() throws Exception {
		final Object beanToMerge = ApplicationContextManager.getBean(idExtensionToMerge, idBeanToMerge);
		if (beanToMerge instanceof Map<?, ?>) {
			return (Map<Object, Object>) beanToMerge;
		}
		final String methodName = "get" + mapToMerge.substring(0, 1).toUpperCase() + mapToMerge.substring(1);
		final Class<?> noparams[] = {};
		final Object noargs[] = {};
		final Method method = beanToMerge.getClass().getMethod(methodName, noparams);
		return (Map<Object, Object>) method.invoke(beanToMerge, noargs);
	}

	@Override
	public boolean isMandatory() {
		return mandatory;
	}

	public void setMandatory(final boolean mandatory) {
		this.mandatory = mandatory;
	}

	public void setMapToMerge(final String mapToMerge) {
		this.mapToMerge = mapToMerge;
	}
}
