/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.logging;

import java.util.Date;
import java.util.LinkedList;

import ch.qos.logback.classic.Level;

import com.kportal.core.cluster.ClusterHelper;

public class ApplicationLogger {

	public static LinkedList<ApplicationLog> pile = new LinkedList<ApplicationLog>();

	public static void reset() {
		pile.clear();
	}

	public static void add(Level level, String message, String exception) {
		ApplicationLog log = new ApplicationLog();
		log.setServer(ClusterHelper.getCurrentJvmRoute());
		log.setDate(new Date(System.currentTimeMillis()));
		log.setLevel(level);
		log.setDescription(message);
		log.setException(exception);
		pile.addFirst(log);
	}

	public static void error(String message, Exception exception) {
		add(Level.ERROR, message, exception.getMessage());
	}

	public static void error(String message) {
		add(Level.ERROR, message, "");
	}

	public static void info(String message, Exception exception) {
		add(Level.INFO, message, exception.getMessage());
	}

	public static void info(String message) {
		add(Level.INFO, message, "");
	}
}
